﻿#include  "StdAfx.h"
#include  "Pidl.hpp"
#include  <szPath.hpp>

using namespace szpp;

bool IsEmpty(PCUIDLIST_RELATIVE pidl)
{
  assert(pidl != 0);
  return 0 == pidl->mkid.cb;
}

szstring ExtractName(PCUIDLIST_RELATIVE pidl)
{
  return szstring((const szchar *)pidl->mkid.abID);
}

szstring RelativePidlToPath(PCUIDLIST_RELATIVE pidl)
{
  if (IsEmpty(pidl))
    return SZL_EMPTY;

  szstring path;

  do
  {
    szstring item = ExtractName(pidl);
    if (!path.empty())
      path = Combine(path, item); // path にセパレータと item を付加
    else
      path.assign(item); // 最上位は先頭にセパレータが不要なので直接 assign
  } while (0 != (pidl = ILGetNext(pidl)) && 0 != pidl->mkid.cb);

  return path;
}

PUIDLIST_RELATIVE NameToPidl(const szstring &name)
{
  // sizeof(ITEMIDLIST) は使えない（ab[1] のせいで 3 バイトになってしまう）
  ULONG size = (ULONG)(  sizeof(USHORT) /* cb */
                       + (name.size() + 1) * sizeof(szchar) /* number of BChar + 1 (for null) */
                       + sizeof(USHORT) /* for terminator */ );

  PUIDLIST_RELATIVE pidlNew = static_cast<PUIDLIST_RELATIVE>(CoTaskMemAlloc(size));
  if (0 != pidlNew)
  {
    memset(pidlNew, 0, size);

    pidlNew->mkid.cb = (USHORT)size - sizeof(USHORT);
    lstrcpyn((LPTSTR)pidlNew->mkid.abID, name.c_str(), (int)(name.size() + 1));
  }
  return pidlNew;
}
